<?php $__env->startSection('title', 'Detail Approval Cuti'); ?>
<?php $__env->startPush('styles'); ?>


<style>
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', 'Roboto', sans-serif;
    }

    body {
        margin: 0;
        padding: 0;
        background: #ffffff;
        overflow: hidden;
    }

    /* ===== DETAIL WRAPPER - FULLSCREEN ===== */
    .approval-detail-wrapper {
        margin-top: 70px; /* Account for header */
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        display: flex;
        flex-direction: column;
        background: #ffffff;
    }

    /* ===== HEADER ===== */
    .detail-header {
        display: flex;
        align-items: center;
        gap: 16px;
        padding: 16px 20px;
        background: white;
        border-bottom: 1px solid #e9ecef;
        flex-shrink: 0;
    }

    .detail-header h1 {
        font-size: 18px;
        font-weight: 600;
        color: #212529;
        margin: 0;
    }

    .back-btn {
        width: 40px;
        height: 40px;
        border-radius: 8px;
        background: #f0f0f0;
        color: #212529;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 16px;
        text-decoration: none;
        transition: all 0.2s;
        cursor: pointer;
        flex-shrink: 0;
    }

    .back-btn:active {
        background: #e0e0e0;
    }

    /* ===== CONTENT AREA ===== */
    .detail-content {
        flex: 1;
        overflow-y: auto;
        -webkit-overflow-scrolling: touch;
        padding: 0;
        background: #ffffff;
    }

    /* ===== DETAIL SECTIONS ===== */
    .detail-section {
        padding: 16px 20px;
        border-bottom: 1px solid #f0f0f0;
        background: white;
    }

    .section-title {
        font-size: 14px;
        font-weight: 700;
        color: #212529;
        margin-bottom: 14px;
        display: flex;
        align-items: center;
        gap: 8px;
        padding-bottom: 10px;
        border-bottom: 2px solid #e9ecef;
    }

    .section-title i {
        font-size: 16px;
        color: #4285f4;
    }

    /* Detail Row */
    .detail-row {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 12px 0;
        border-bottom: 1px solid #f0f0f0;
    }

    .detail-row:last-child {
        border-bottom: none;
    }

    .detail-label {
        font-size: 12px;
        color: #6c757d;
        font-weight: 700;
        text-transform: uppercase;
    }

    .detail-value {
        font-size: 14px;
        color: #212529;
        font-weight: 600;
        text-align: right;
    }

    /* Reason */
    .detail-reason {
        font-size: 14px;
        color: #495057;
        line-height: 1.6;
        margin: 0;
        word-break: break-word;
    }

    /* Badge */
    .badge {
        display: inline-block;
        padding: 6px 12px;
        border-radius: 12px;
        font-size: 12px;
        font-weight: 700;
    }

    .badge-orange {
        background: linear-gradient(135deg, #FF6B35 0%, #F7931E 100%);
        color: white;
    }

    /* File Link */
    .file-link {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        color: #4285f4;
        text-decoration: none;
        font-weight: 600;
        font-size: 14px;
        padding: 8px 12px;
        background: #f0f7ff;
        border-radius: 6px;
        transition: all 0.2s;
    }

    .file-link:active {
        background: #e0f0ff;
    }

    /* ===== TIMELINE ===== */
    .timeline {
        position: relative;
        padding: 10px 0;
    }

    .timeline-item {
        display: flex;
        gap: 16px;
        margin-bottom: 16px;
        position: relative;
    }

    .timeline-item:not(:last-child)::before {
        content: '';
        position: absolute;
        left: 15px;
        top: 44px;
        width: 2px;
        height: calc(100% + 4px);
        background: #e9ecef;
    }

    .timeline-marker {
        width: 32px;
        height: 32px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-shrink: 0;
        font-weight: 700;
        color: white;
        font-size: 14px;
    }

    .timeline-marker.pending {
        background: #fff3cd;
        color: #856404;
        border: 2px solid #ffc107;
    }

    .timeline-marker.disetujui {
        background: #28a745;
    }

    .timeline-marker.ditolak {
        background: #dc3545;
    }

    .timeline-body {
        flex: 1;
        padding-top: 4px;
    }

    .timeline-step {
        font-size: 13px;
        font-weight: 700;
        color: #212529;
        margin-bottom: 2px;
    }

    .timeline-time {
        font-size: 12px;
        color: #6c757d;
    }

    /* ===== ACTION BUTTONS ===== */
    .detail-actions {
        display: flex;
        gap: 10px;
        padding: 16px 20px;
        background: white;
        border-top: 1px solid #e9ecef;
        flex-shrink: 0;
    }

    .btn {
        flex: 1;
        padding: 12px 16px;
        border: none;
        border-radius: 8px;
        font-size: 13px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.2s;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 6px;
        text-decoration: none;
        color: inherit;
    }

    .btn-secondary {
        background: #e9ecef;
        color: #212529;
    }

    .btn-secondary:active {
        background: #dee2e6;
    }

    .btn-approve {
        background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
        color: white;
    }

    .btn-approve:active {
        transform: scale(0.98);
    }

    .btn-reject {
        background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
        color: white;
    }

    .btn-reject:active {
        transform: scale(0.98);
    }

    .btn-disabled {
        background: #e9ecef;
        color: #6c757d;
        cursor: not-allowed;
        opacity: 0.6;
    }

    /* ===== MODAL ===== */
    .modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        z-index: 2000;
        align-items: flex-end;
        justify-content: center;
        padding: 20px;
    }

    .modal.show {
        display: flex;
    }

    .modal-overlay {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background: rgba(0, 0, 0, 0.5);
        z-index: -1;
    }

    .modal-content {
        background: white;
        padding: 20px;
        border-radius: 20px 20px 0 0;
        width: 100%;
        max-width: 500px;
        max-height: 90vh;
        overflow-y: auto;
        -webkit-overflow-scrolling: touch;
        animation: slideUp 0.3s ease-out;
    }

    @keyframes slideUp {
        from {
            transform: translateY(100%);
        }
        to {
            transform: translateY(0);
        }
    }

    .modal-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 16px;
        padding-bottom: 12px;
        border-bottom: 1px solid #e9ecef;
    }

    .modal-header h3 {
        font-size: 16px;
        font-weight: 700;
        color: #212529;
        margin: 0;
    }

    .modal-close {
        background: none;
        border: none;
        color: #6c757d;
        font-size: 18px;
        cursor: pointer;
        padding: 0;
        width: 32px;
        height: 32px;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: color 0.2s;
    }

    .modal-close:active {
        color: #212529;
    }

    .modal-body {
        display: flex;
        flex-direction: column;
        gap: 14px;
    }

    .form-group {
        display: flex;
        flex-direction: column;
        gap: 6px;
    }

    .form-group label {
        font-size: 13px;
        font-weight: 700;
        color: #212529;
    }

    .form-group .required {
        color: #dc3545;
    }

    .form-group textarea {
        padding: 10px;
        border: 2px solid #e9ecef;
        border-radius: 8px;
        font-size: 14px;
        font-family: inherit;
        resize: vertical;
        transition: border-color 0.2s;
    }

    .form-group textarea:focus {
        outline: none;
        border-color: #4285f4;
    }

    .form-group small {
        font-size: 11px;
        color: #6c757d;
    }

    .modal-footer {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 10px;
        margin-top: 14px;
        padding-top: 14px;
        border-top: 1px solid #e9ecef;
    }

    .btn-modal {
        padding: 10px 14px;
        border: none;
        border-radius: 8px;
        font-size: 13px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.2s;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 6px;
    }

    .btn-cancel {
        background: #e9ecef;
        color: #212529;
    }

    .btn-cancel:active {
        background: #dee2e6;
    }

    .btn-submit {
        background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
        color: white;
    }

    .btn-submit:active {
        transform: scale(0.98);
    }

    /* ===== TABLET & DESKTOP RESPONSIVENESS ===== */
    @media (min-width: 769px) {
        .approval-detail-wrapper {
            margin-top: 70px;
            position: relative;
        }

        .detail-header {
            padding: 20px;
            border-bottom: 2px solid #e9ecef;
        }

        .detail-header h1 {
            font-size: 26px;
        }

        .back-btn {
            width: 44px;
            height: 44px;
            font-size: 18px;
            background: #e9ecef;
        }

        .detail-content {
            margin-bottom: 0;
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }

        .detail-section {
            padding: 20px;
            border-radius: 12px;
            border: 1px solid #e9ecef;
            border-bottom: none;
            margin-bottom: 20px;
            background: white;
        }

        .detail-section:last-of-type {
            border-bottom: 1px solid #e9ecef;
        }

        .section-title {
            font-size: 15px;
            margin-bottom: 16px;
            padding-bottom: 12px;
        }

        .detail-row {
            padding: 14px 0;
        }

        .detail-actions {
            max-width: 800px;
            margin: 0 auto;
            width: 100%;
            padding: 20px;
            border-top: 2px solid #e9ecef;
        }

        .btn {
            padding: 12px 24px;
            font-size: 14px;
        }

        .modal-content {
            border-radius: 12px;
            max-width: 500px;
        }
    }

    /* ===== TABLET RESPONSIVE (480px - 768px) ===== */
    @media (max-width: 768px) and (min-width: 481px) {
        .detail-header {
            padding: 14px 16px;
        }

        .detail-header h1 {
            font-size: 16px;
        }

        .detail-section {
            padding: 14px 16px;
        }

        .section-title {
            font-size: 13px;
            margin-bottom: 12px;
        }

        .detail-row {
            padding: 10px 0;
        }

        .detail-label {
            font-size: 11px;
        }

        .detail-value {
            font-size: 13px;
        }

        .detail-actions {
            padding: 14px 16px;
            gap: 8px;
        }

        .btn {
            padding: 10px 14px;
            font-size: 12px;
        }
    }

    /* ===== MOBILE RESPONSIVE (< 480px) ===== */
    @media (max-width: 480px) {
        .detail-header {
            padding: 12px 14px;
            gap: 12px;
        }

        .detail-header h1 {
            font-size: 15px;
        }

        .back-btn {
            width: 36px;
            height: 36px;
            font-size: 14px;
        }

        .detail-section {
            padding: 12px 14px;
        }

        .section-title {
            font-size: 12px;
            margin-bottom: 10px;
            padding-bottom: 8px;
            gap: 6px;
        }

        .section-title i {
            font-size: 14px;
        }

        .detail-row {
            padding: 8px 0;
            flex-direction: column;
            align-items: flex-start;
            gap: 4px;
        }

        .detail-value {
            text-align: left;
        }

        .detail-label {
            font-size: 10px;
        }

        .detail-value {
            font-size: 13px;
        }

        .detail-reason {
            font-size: 13px;
        }

        .badge {
            padding: 4px 10px;
            font-size: 11px;
        }

        .timeline-item {
            gap: 12px;
            margin-bottom: 12px;
        }

        .timeline-item:not(:last-child)::before {
            left: 13px;
            top: 36px;
        }

        .timeline-marker {
            width: 28px;
            height: 28px;
            font-size: 12px;
        }

        .timeline-step {
            font-size: 12px;
        }

        .timeline-time {
            font-size: 11px;
        }

        .detail-actions {
            padding: 12px 14px;
            gap: 8px;
        }

        .btn {
            padding: 10px 12px;
            font-size: 11px;
            gap: 4px;
        }

        .btn i {
            font-size: 12px;
        }

        .modal-content {
            border-radius: 20px 20px 0 0;
            padding: 16px;
        }

        .modal-header {
            margin-bottom: 12px;
            padding-bottom: 10px;
        }

        .modal-header h3 {
            font-size: 14px;
        }

        .form-group label {
            font-size: 12px;
        }

        .form-group textarea {
            font-size: 13px;
            padding: 8px;
        }

        .btn-modal {
            padding: 8px 12px;
            font-size: 12px;
        }
    }

    /* ===== EXTRA SMALL (< 360px) ===== */
    @media (max-width: 360px) {
        .detail-header {
            padding: 10px 12px;
        }

        .detail-header h1 {
            font-size: 14px;
        }

        .detail-section {
            padding: 10px 12px;
        }

        .section-title {
            font-size: 11px;
        }

        .detail-label {
            font-size: 9px;
        }

        .detail-value {
            font-size: 12px;
        }

        .btn {
            padding: 8px 10px;
            font-size: 10px;
        }

        .btn i {
            font-size: 10px;
        }
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<div class="approval-detail-wrapper">
    <!-- Header dengan Back Button -->

    <!-- Content Area -->
    <div class="detail-content">
        <!-- Section: Employee Info -->
        <div class="detail-section">
            <div class="section-title">
                <i class="fas fa-user"></i> Informasi Karyawan
            </div>
            <div class="detail-row">
                <span class="detail-label">Nama</span>
                <span class="detail-value"><?php echo e($cuti->karyawan->user->nama); ?></span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Departemen</span>
                <span class="detail-value"><?php echo e($cuti->karyawan->departemen->nama); ?></span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Posisi</span>
                <span class="detail-value"><?php echo e($cuti->karyawan->jabatan->nama ?? '-'); ?></span>
            </div>
        </div>

        <!-- Section: Cuti Details -->
        <div class="detail-section">
            <div class="section-title">
                <i class="fas fa-calendar-alt"></i> Informasi Cuti
            </div>
            <div class="detail-row">
                <span class="detail-label">Jenis Cuti</span>
                <span class="detail-value">
                    <span class="badge badge-orange"><?php echo e($cuti->jenisCuti->nama); ?></span>
                </span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Tanggal Mulai</span>
                <span class="detail-value"><?php echo e($cuti->tanggal_mulai->format('d F Y')); ?></span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Tanggal Selesai</span>
                <span class="detail-value"><?php echo e($cuti->tanggal_selesai->format('d F Y')); ?></span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Durasi</span>
                <span class="detail-value"><?php echo e($cuti->jumlahHari); ?> hari</span>
            </div>
            <div class="detail-row">
                <span class="detail-label">Diajukan</span>
                <span class="detail-value"><?php echo e($cuti->created_at->format('d F Y, H:i')); ?></span>
            </div>
        </div>

        <!-- Section: Alasan -->
        <div class="detail-section">
            <div class="section-title">
                <i class="fas fa-comment-alt"></i> Alasan Pengajuan
            </div>
            <p class="detail-reason"><?php echo e($cuti->alasan); ?></p>
        </div>

        <!-- Section: File Pendukung -->
        <?php if($cuti->file_pendukung): ?>
        <div class="detail-section">
            <div class="section-title">
                <i class="fas fa-file"></i> File Pendukung
            </div>
            <a href="<?php echo e(Storage::url($cuti->file_pendukung)); ?>" target="_blank" class="file-link">
                <i class="fas fa-download"></i>
                Download File
            </a>
        </div>
        <?php endif; ?>

        <!-- Section: Progress Timeline -->
        <div class="detail-section">
            <div class="section-title">
                <i class="fas fa-list-check"></i> Progress Approval
            </div>
            <div class="timeline">
                <?php $__currentLoopData = $cuti->approvals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $approval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="timeline-item">
                        <div class="timeline-marker <?php echo e($approval->status); ?>">
                            <?php if($approval->status === 'disetujui'): ?>
                                <i class="fas fa-check"></i>
                            <?php elseif($approval->status === 'ditolak'): ?>
                                <i class="fas fa-times"></i>
                            <?php else: ?>
                                <i class="fas fa-hourglass-half"></i>
                            <?php endif; ?>
                        </div>
                        <div class="timeline-body">
                            <div class="timeline-step"><?php echo e(strtoupper($approval->step)); ?></div>
                            <?php if($approval->approved_at): ?>
                                <div class="timeline-time"><?php echo e($approval->approved_at->format('d F Y, H:i')); ?></div>
                            <?php else: ?>
                                <div class="timeline-time">Menunggu...</div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    <!-- Action Buttons -->
    <?php
        $isYourTurn = $cuti->current_step === Auth::user()->role;
    ?>

    <div class="detail-actions">
        <a href="<?php echo e(route('admin.approval')); ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i>
            <span>Kembali</span>
        </a>

        <?php if($isYourTurn): ?>
            <button type="button" class="btn btn-approve" onclick="confirmApprove()">
                <i class="fas fa-check"></i>
                <span>Setujui</span>
            </button>
            <button type="button" class="btn btn-reject" onclick="showRejectModal()">
                <i class="fas fa-times"></i>
                <span>Tolak</span>
            </button>
        <?php else: ?>
            <button type="button" class="btn btn-disabled" disabled>
                <i class="fas fa-lock"></i>
                <span>Menunggu <?php echo e(strtoupper($cuti->current_step)); ?></span>
            </button>
        <?php endif; ?>
    </div>
</div>

<!-- Reject Modal (sama seperti list page) -->
<div id="rejectModal" class="modal">
    <div class="modal-overlay"></div>
    <div class="modal-content">
        <div class="modal-header">
            <h3>Tolak Pengajuan Cuti</h3>
            <button class="modal-close" onclick="closeRejectModal()">
                <i class="fas fa-times"></i>
            </button>
        </div>

        <form id="rejectForm" method="POST" action="<?php echo e(route('admin.cuti.reject', $cuti->id)); ?>" class="modal-body">
            <?php echo csrf_field(); ?>

            <div class="form-group">
                <label>Alasan Penolakan <span class="required">*</span></label>
                <textarea
                    name="catatan_admin"
                    placeholder="Jelaskan alasan penolakan..."
                    required
                    minlength="10"
                    rows="4"
                ></textarea>
                <small>Minimum 10 karakter</small>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn-modal btn-cancel" onclick="closeRejectModal()">
                    Batal
                </button>
                <button type="submit" class="btn-modal btn-submit">
                    <i class="fas fa-times"></i> Tolak
                </button>
            </div>
        </form>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>


<script>
    // ===== REJECT MODAL FUNCTIONS =====

    function showRejectModal() {
        document.getElementById('rejectModal').classList.add('show');
        document.body.style.overflow = 'hidden';
        document.getElementById('rejectForm').querySelector('textarea').focus();
    }

    function closeRejectModal() {
        document.getElementById('rejectModal').classList.remove('show');
        document.body.style.overflow = '';
        document.getElementById('rejectForm').reset();
    }

    // Close modal when clicking overlay
    document.addEventListener('DOMContentLoaded', function() {
        const modal = document.getElementById('rejectModal');
        const overlay = modal.querySelector('.modal-overlay');

        if (overlay) {
            overlay.addEventListener('click', closeRejectModal);
        }

        // Close modal dengan ESC
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape') {
                closeRejectModal();
            }
        });
    });

    // ===== APPROVAL FUNCTIONS =====

    function confirmApprove() {
        if (confirm('Setujui pengajuan cuti ini?')) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = `<?php echo e(route('admin.cuti.approve', $cuti->id)); ?>`;
            form.innerHTML = `
                <?php echo csrf_field(); ?>
                <input type="hidden" name="catatan_admin" value="">
            `;
            document.body.appendChild(form);
            form.submit();
        }
    }

    // ===== NOTIFICATIONS =====

    document.addEventListener('DOMContentLoaded', function() {
        <?php if(session('success')): ?>
            showNotification('<?php echo e(session('success')); ?>', 'success');
        <?php endif; ?>
        <?php if(session('error')): ?>
            showNotification('<?php echo e(session('error')); ?>', 'error');
        <?php endif; ?>
    });

    function showNotification(message, type = 'success') {
        const toast = document.createElement('div');
        toast.style.cssText = `
            position: fixed;
            bottom: 100px;
            left: 50%;
            transform: translateX(-50%);
            padding: 12px 16px;
            background: ${type === 'success' ? '#28a745' : '#dc3545'};
            color: white;
            border-radius: 8px;
            font-weight: 600;
            font-size: 13px;
            z-index: 3000;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            animation: slideInUp 0.3s ease-out;
        `;
        toast.textContent = message;
        document.body.appendChild(toast);

        setTimeout(() => {
            toast.style.animation = 'slideInUp 0.3s ease-out reverse';
            setTimeout(() => toast.remove(), 300);
        }, 4000);
    }
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make(is_admin_mode()
    ? 'admin.layouts.app'
    : 'karyawan.layout.fullscreen', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\DAVA\Documents\FILE_SEKOLAH\WEB XII\absensi-hotel - Copy\resources\views/admin/approval/cuti-detail.blade.php ENDPATH**/ ?>